/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;

public abstract class AbstractBlockIterator
implements SequenceIterator {
    protected int size;
    protected int currentOperand;
    protected SequenceIterator currentIter;
    protected XPathContext context;
    private boolean releaseResources;

    public AbstractBlockIterator() {
    }

    public AbstractBlockIterator(int size, XPathContext context) {
        this.size = size;
        this.context = context;
        this.currentOperand = 0;
    }

    public void init(int size, XPathContext context) {
        this.size = size;
        this.context = context;
        this.currentOperand = 0;
    }

    @Override
    public void discharge() {
        this.releaseResources = true;
    }

    @Override
    public Item next() {
        if (this.currentOperand < 0) {
            return null;
        }
        do {
            Item current;
            if (this.currentIter == null) {
                try {
                    this.currentIter = this.getNthChildIterator(this.currentOperand++);
                    if (this.releaseResources) {
                        this.currentIter.discharge();
                    }
                }
                catch (XPathException e) {
                    throw new UncheckedXPathException(e);
                }
            }
            if ((current = this.currentIter.next()) != null) {
                return current;
            }
            this.currentIter = null;
        } while (this.currentOperand < this.size);
        this.currentOperand = -1;
        return null;
    }

    public abstract SequenceIterator getNthChildIterator(int var1) throws XPathException;

    @Override
    public void close() {
        if (this.currentIter != null) {
            this.currentIter.close();
        }
        this.currentOperand = -1;
    }
}

