/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.om.Durability;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyAttributeImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.z.IntHashMap;

public class MemoFunction
extends UserFunction {
    private boolean lookForNodes = false;

    @Override
    public void setParameterDefinitions(UserFunctionParameter[] params) {
        super.setParameterDefinitions(params);
        for (UserFunctionParameter param : params) {
            if (!param.getRequiredType().getPrimaryType().getUType().overlaps(UType.ANY_NODE)) continue;
            this.lookForNodes = true;
        }
    }

    @Override
    public void computeEvaluationMode() {
        this.bodyEvaluator = this.getBody().makeElaborator().eagerly();
    }

    @Override
    public boolean isMemoFunction() {
        return true;
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] actualArgs) throws XPathException {
        for (int i = 0; i < actualArgs.length; ++i) {
            actualArgs[i] = actualArgs[i].materialize();
        }
        Controller controller = context.getController();
        MemoFunctionCache cache = (MemoFunctionCache)controller.getUserData(this, "memo-function-cache");
        if (cache == null) {
            cache = new MemoFunctionCache(this.lookForNodes);
            controller.setUserData(this, "memo-function-cache", cache);
        }
        Sequence[] savedArgs = this.isTailRecursive() || this.containsTailCalls() ? Arrays.copyOf(actualArgs, actualArgs.length) : actualArgs;
        int hash = cache.hash(actualArgs);
        GroundedValue value = cache.get(hash, actualArgs);
        if (value != null) {
            return value;
        }
        value = super.call(context, actualArgs).materialize();
        cache.put(hash, savedArgs, value);
        return value;
    }

    private static Item substitute(NodeInfo node) {
        Durability durability = node.getTreeInfo().getDurability();
        if (durability == null) {
            durability = Durability.LASTING;
        }
        switch (durability) {
            case LASTING: 
            case UNDEFINED: {
                return node;
            }
            case TEMPORARY: {
                return new NodeSurrogate(node);
            }
        }
        return null;
    }

    private static class MemoFunctionCache {
        private final boolean lookForNodes;
        private final IntHashMap<List<GroundedValue>> cacheMap = new IntHashMap();

        public MemoFunctionCache(boolean lookForNodes) {
            this.lookForNodes = lookForNodes;
        }

        public int hash(Sequence[] args) {
            int h = 949110699;
            for (Sequence arg : args) {
                GroundedValue val = (GroundedValue)arg;
                if (val instanceof Item) {
                    h ^= this.hashItem((Item)val) + 1;
                    continue;
                }
                for (Item item : val.asIterable()) {
                    h ^= this.hashItem(item) + 1;
                }
            }
            return h;
        }

        private int hashItem(Item it) {
            return it.hashCode();
        }

        public GroundedValue get(int hash, Sequence[] args) {
            int arity = args.length;
            List<GroundedValue> bucket = this.cacheMap.get(hash);
            if (bucket == null) {
                return null;
            }
            for (int i = 0; i < bucket.size(); i += arity + 1) {
                boolean found = true;
                for (int j = 0; j < arity; ++j) {
                    if (this.sameValue((GroundedValue)args[j], bucket.get(i + j))) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                return bucket.get(i + arity);
            }
            return null;
        }

        private boolean sameValue(GroundedValue v0, GroundedValue v1) {
            if (v0.getLength() != v1.getLength()) {
                return false;
            }
            for (int i = 0; i < v0.getLength(); ++i) {
                Item it1;
                Item it0 = v0.itemAt(i);
                if (it0 == (it1 = v1.itemAt(i))) continue;
                Genre g0 = it0.getGenre();
                if (g0 == Genre.NODE) {
                    if (it1 instanceof NodeSurrogate) {
                        return (Boolean)((Function)((NodeSurrogate)it1).getObject()).apply((NodeInfo)it0);
                    }
                    return false;
                }
                if (g0 != it1.getGenre()) {
                    return false;
                }
                if (it0.getGenre() == Genre.ATOMIC) {
                    AtomicValue av0 = (AtomicValue)it0;
                    AtomicValue av1 = (AtomicValue)it1;
                    if (!av0.getItemType().equals(av1.getItemType())) {
                        return false;
                    }
                    if (!av0.isIdentical(av1)) {
                        return false;
                    }
                    if (!(av0 instanceof NumericValue) || ((NumericValue)av0).isNegativeZero() == ((NumericValue)av1).isNegativeZero()) continue;
                    return false;
                }
                if (it0.equals(it1)) continue;
                return false;
            }
            return true;
        }

        public void put(int hash, Sequence[] args, GroundedValue result) {
            List<GroundedValue> bucket = this.cacheMap.get(hash);
            if (bucket == null) {
                bucket = new ArrayList<GroundedValue>(args.length + 1);
                this.cacheMap.put(hash, bucket);
            }
            int initialSize = bucket.size();
            for (Sequence val : args) {
                GroundedValue gVal = (GroundedValue)val;
                if (gVal instanceof AtomicValue || gVal instanceof FunctionItem || gVal instanceof EmptySequence) {
                    bucket.add(gVal);
                    continue;
                }
                if (gVal instanceof NodeInfo) {
                    Item subs = MemoFunction.substitute((NodeInfo)gVal);
                    if (subs == null) {
                        return;
                    }
                    bucket.add(subs);
                    continue;
                }
                if (this.lookForNodes) {
                    Item it;
                    SequenceIterator iter = gVal.iterate();
                    ArrayList<Item> newSeq = new ArrayList<Item>(gVal.getLength());
                    while ((it = iter.next()) != null) {
                        if (it instanceof NodeInfo) {
                            Item subs = MemoFunction.substitute((NodeInfo)it);
                            if (subs == null) {
                                while (bucket.size() > initialSize) {
                                    bucket.remove(bucket.size() - 1);
                                }
                                return;
                            }
                            newSeq.add(subs);
                            continue;
                        }
                        newSeq.add(it);
                    }
                    bucket.add(SequenceExtent.makeSequenceExtent(newSeq));
                    continue;
                }
                bucket.add(gVal);
            }
            bucket.add(result);
        }
    }

    public static class NodeSurrogate
    extends ObjectValue<Function<NodeInfo, Boolean>> {
        protected NodeSurrogate(NodeInfo node) {
            super(NodeSurrogate.matcher(node));
        }

        private static Function<NodeInfo, Boolean> matcher(NodeInfo node) {
            if (node instanceof TinyAttributeImpl) {
                long docNr = node.getTreeInfo().getDocumentNumber();
                int nodeNr = ((TinyNodeImpl)node).getNodeNumber();
                return node1 -> node1 instanceof TinyAttributeImpl && docNr == node1.getTreeInfo().getDocumentNumber() && nodeNr == ((TinyNodeImpl)node1).getNodeNumber();
            }
            if (node instanceof TinyNodeImpl) {
                long docNr = node.getTreeInfo().getDocumentNumber();
                int nodeNr = ((TinyNodeImpl)node).getNodeNumber();
                return node1 -> node1 instanceof TinyNodeImpl && docNr == node1.getTreeInfo().getDocumentNumber() && nodeNr == ((TinyNodeImpl)node1).getNodeNumber();
            }
            String generatedId = NodeSurrogate.generateId(node);
            return node1 -> generatedId.equals(NodeSurrogate.generateId(node1));
        }

        private static String generateId(NodeInfo node) {
            StringBuilder sb = new StringBuilder();
            node.generateId(sb);
            return sb.toString();
        }
    }
}

