/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.Objects;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.XPathComparable;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.ContextFreeAtomicValue;
import net.sf.saxon.value.DurationValue;

public final class DayTimeDurationValue
extends DurationValue
implements XPathComparable,
ContextFreeAtomicValue {
    private DayTimeDurationValue() {
        this.typeLabel = BuiltInAtomicType.DAY_TIME_DURATION;
    }

    public static ConversionResult makeDayTimeDurationValue(UnicodeString s) {
        ConversionResult d = DurationValue.makeDuration(s, false, true);
        if (d instanceof ValidationFailure) {
            return d;
        }
        DurationValue dv = (DurationValue)d;
        return Converter.DurationToDayTimeDuration.INSTANCE.convert(dv);
    }

    public DayTimeDurationValue(int sign, int days, int hours, int minutes, long seconds, int microseconds) throws IllegalArgumentException {
        if (days < 0 || hours < 0 || minutes < 0 || seconds < 0L || microseconds < 0) {
            throw new IllegalArgumentException("Negative component value");
        }
        if ((double)days * 86400.0 + (double)hours * 3600.0 + (double)minutes * 60.0 + (double)seconds > 9.223372036854776E18) {
            throw new IllegalArgumentException("Duration seconds limit exceeded");
        }
        this._negative = sign < 0;
        this._months = 0;
        long h = (long)days * 24L + (long)hours;
        long m = h * 60L + (long)minutes;
        long s = m * 60L + seconds;
        if (microseconds > 1000000) {
            s += (long)(microseconds / 1000000);
            microseconds %= 1000000;
        }
        this._seconds = s;
        this._nanoseconds = microseconds * 1000;
        if (s == 0L && microseconds == 0) {
            this._negative = false;
        }
        this.typeLabel = BuiltInAtomicType.DAY_TIME_DURATION;
    }

    public DayTimeDurationValue(int days, int hours, int minutes, long seconds, int nanoseconds) throws IllegalArgumentException {
        boolean someNegative;
        boolean somePositive = days > 0 || hours > 0 || minutes > 0 || seconds > 0L || nanoseconds > 0;
        boolean bl = someNegative = days < 0 || hours < 0 || minutes < 0 || seconds < 0L || nanoseconds < 0;
        if (somePositive && someNegative) {
            throw new IllegalArgumentException("Some component values are positive and others are negative");
        }
        if (someNegative) {
            this._negative = true;
            days = -days;
            hours = -hours;
            minutes = -minutes;
            seconds = -seconds;
            nanoseconds = -nanoseconds;
        }
        if ((double)days * 86400.0 + (double)hours * 3600.0 + (double)minutes * 60.0 + (double)seconds > 9.223372036854776E18) {
            throw new IllegalArgumentException("Duration seconds limit exceeded");
        }
        this._months = 0;
        long h = (long)days * 24L + (long)hours;
        long m = h * 60L + (long)minutes;
        long s = m * 60L + seconds;
        if (nanoseconds > 1000000000) {
            s += (long)(nanoseconds / 1000000000);
            nanoseconds %= 1000000000;
        }
        this._seconds = s;
        this._nanoseconds = nanoseconds;
        this.typeLabel = BuiltInAtomicType.DAY_TIME_DURATION;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        DayTimeDurationValue v = DayTimeDurationValue.fromSeconds(this.getTotalSeconds());
        v.typeLabel = typeLabel;
        return v;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DAY_TIME_DURATION;
    }

    @Override
    public UnicodeString getPrimitiveStringValue() {
        UnicodeBuilder sb = new UnicodeBuilder();
        if (this._negative) {
            sb.append('-');
        }
        int days = this.getDays();
        int hours = this.getHours();
        int minutes = this.getMinutes();
        int seconds = this.getSeconds();
        sb.append('P');
        if (days != 0) {
            sb.append(days + "D");
        }
        if (days == 0 || hours != 0 || minutes != 0 || seconds != 0 || this._nanoseconds != 0) {
            sb.append('T');
        }
        if (hours != 0) {
            sb.append(hours + "H");
        }
        if (minutes != 0) {
            sb.append(minutes + "M");
        }
        if (seconds != 0 || this._nanoseconds != 0 || days == 0 && minutes == 0 && hours == 0) {
            if (this._nanoseconds == 0) {
                sb.append(seconds + "S");
            } else {
                DayTimeDurationValue.formatFractionalSeconds(sb, seconds, (long)seconds * 1000000000L + (long)this._nanoseconds);
            }
        }
        return sb.toUnicodeString();
    }

    @Override
    public double getLengthInSeconds() {
        double a = (double)this._seconds + (double)this._nanoseconds / 1.0E9;
        return this._negative ? -a : a;
    }

    public long getLengthInMicroseconds() {
        if (this._seconds > 9223372036854L) {
            throw new ArithmeticException("Value is too large to be expressed in microseconds");
        }
        long a = this._seconds * 1000000L + (long)(this._nanoseconds / 1000);
        return this._negative ? -a : a;
    }

    public long getLengthInNanoseconds() {
        if (this._seconds > 9223372036L) {
            throw new ArithmeticException("Value is too large to be expressed in nanoseconds");
        }
        long a = this._seconds * 1000000000L + (long)this._nanoseconds;
        return this._negative ? -a : a;
    }

    public static DayTimeDurationValue fromSeconds(BigDecimal seconds) {
        DayTimeDurationValue sdv = new DayTimeDurationValue();
        boolean bl = sdv._negative = seconds.signum() < 0;
        if (sdv._negative) {
            seconds = seconds.negate();
        }
        BigInteger wholeSeconds = seconds.toBigInteger();
        sdv._seconds = wholeSeconds.longValueExact();
        BigDecimal fractionalPart = seconds.remainder(BigDecimal.ONE);
        BigDecimal nanoseconds = fractionalPart.multiply(BigDecimalValue.BIG_DECIMAL_ONE_BILLION);
        sdv._nanoseconds = nanoseconds.intValue();
        if (sdv._seconds == 0L && sdv._nanoseconds == 0) {
            sdv._negative = false;
        }
        return sdv;
    }

    public static DayTimeDurationValue fromMilliseconds(long milliseconds) throws ValidationException {
        int sign = Long.signum(milliseconds);
        if (sign < 0) {
            milliseconds = -milliseconds;
        }
        try {
            return new DayTimeDurationValue(sign, 0, 0, 0, milliseconds / 1000L, (int)(milliseconds % 1000L) * 1000);
        }
        catch (IllegalArgumentException err) {
            throw new ValidationFailure("Duration exceeds limits").makeException();
        }
    }

    public static DayTimeDurationValue fromMicroseconds(long microseconds) throws IllegalArgumentException {
        int sign = Long.signum(microseconds);
        if (sign < 0) {
            microseconds = -microseconds;
        }
        return new DayTimeDurationValue(sign, 0, 0, 0, microseconds / 1000000L, (int)(microseconds % 1000000L));
    }

    public static DayTimeDurationValue fromNanoseconds(long nanoseconds) throws IllegalArgumentException {
        return new DayTimeDurationValue(0, 0, 0, nanoseconds / 1000000000L, (int)(nanoseconds % 1000000000L));
    }

    public static DayTimeDurationValue fromJavaDuration(Duration duration) {
        long seconds = duration.getSeconds();
        int nanoseconds = duration.getNano();
        boolean negative = false;
        if (seconds < 0L) {
            return new DayTimeDurationValue(0, 0, 0, seconds, -1000000000 + nanoseconds);
        }
        return new DayTimeDurationValue(0, 0, 0, seconds, nanoseconds);
    }

    public Duration toJavaDuration() {
        if (this._negative) {
            return Duration.ofSeconds(-this._seconds, -this._nanoseconds);
        }
        return Duration.ofSeconds(this._seconds, this._nanoseconds);
    }

    @Override
    public DurationValue multiply(long factor) throws XPathException {
        if (Math.abs(factor) < Integer.MAX_VALUE && Math.abs(this._seconds) < Integer.MAX_VALUE) {
            return new DayTimeDurationValue(0, 0, 0, this._seconds * factor * (long)(this._negative ? -1 : 1), (int)((long)this._nanoseconds * factor * (long)(this._negative ? -1 : 1)));
        }
        return this.multiply(BigDecimal.valueOf(factor));
    }

    @Override
    public DayTimeDurationValue multiply(double n) throws XPathException {
        if (Double.isNaN(n)) {
            XPathException err = new XPathException("Cannot multiply a duration by NaN");
            err.setErrorCode("FOCA0005");
            throw err;
        }
        if (Double.isInfinite(n)) {
            XPathException err = new XPathException("Cannot multiply a duration by infinity");
            err.setErrorCode("FODT0002");
            throw err;
        }
        BigDecimal factor = BigDecimal.valueOf(n);
        return this.multiply(factor);
    }

    @Override
    public DayTimeDurationValue multiply(BigDecimal factor) throws XPathException {
        BigDecimal secs = this.getTotalSeconds();
        BigDecimal product = secs.multiply(factor);
        try {
            return DayTimeDurationValue.fromSeconds(product);
        }
        catch (ArithmeticException | IllegalArgumentException err) {
            if (err.getCause() instanceof XPathException) {
                throw (XPathException)err.getCause();
            }
            XPathException err2 = new XPathException("Overflow when multiplying a duration by a number", err);
            err2.setErrorCode("FODT0002");
            throw err2;
        }
    }

    @Override
    public DurationValue divide(double n) throws XPathException {
        if (Double.isNaN(n)) {
            XPathException err = new XPathException("Cannot divide a duration by NaN");
            err.setErrorCode("FOCA0005");
            throw err;
        }
        if (n == 0.0) {
            XPathException err = new XPathException("Cannot divide a duration by zero");
            err.setErrorCode("FODT0002");
            throw err;
        }
        BigDecimal secs = this.getTotalSeconds();
        BigDecimal product = secs.divide(BigDecimal.valueOf(n));
        try {
            return DayTimeDurationValue.fromSeconds(product);
        }
        catch (ArithmeticException | IllegalArgumentException err) {
            if (err.getCause() instanceof XPathException) {
                throw (XPathException)err.getCause();
            }
            XPathException err2 = new XPathException("Overflow when dividing a duration by a number", err);
            err2.setErrorCode("FODT0002");
            throw err2;
        }
    }

    @Override
    public BigDecimalValue divide(DurationValue other) throws XPathException {
        if (other instanceof DayTimeDurationValue) {
            BigDecimal v1 = this.getTotalSeconds();
            BigDecimal v2 = other.getTotalSeconds();
            if (v2.signum() == 0) {
                throw new XPathException("Divide by zero (durations)", "FOAR0001");
            }
            return new BigDecimalValue(v1.divide(v2, 20, RoundingMode.HALF_EVEN));
        }
        XPathException err = new XPathException("Cannot divide two durations of different type");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    @Override
    public DurationValue add(DurationValue other) throws XPathException {
        if (other instanceof DayTimeDurationValue) {
            DayTimeDurationValue d2 = (DayTimeDurationValue)other;
            if (((this._seconds | d2._seconds) & 0x7FFFFFFF00000000L) != 0L) {
                try {
                    BigDecimal v1 = this.getTotalSeconds();
                    BigDecimal v2 = other.getTotalSeconds();
                    return DayTimeDurationValue.fromSeconds(v1.add(v2));
                }
                catch (IllegalArgumentException e) {
                    XPathException err = new XPathException("Overflow when adding two durations");
                    err.setErrorCode("FODT0002");
                    throw err;
                }
            }
            return DayTimeDurationValue.fromNanoseconds(this.getLengthInNanoseconds() + d2.getLengthInNanoseconds());
        }
        XPathException err = new XPathException("Cannot add two durations of different type");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    @Override
    public DurationValue subtract(DurationValue other) throws XPathException {
        if (other instanceof DayTimeDurationValue) {
            DayTimeDurationValue d2 = (DayTimeDurationValue)other;
            if (((this._seconds | d2._seconds) & 0x7FFFFFFF00000000L) != 0L) {
                try {
                    BigDecimal v1 = this.getTotalSeconds();
                    BigDecimal v2 = other.getTotalSeconds();
                    return DayTimeDurationValue.fromSeconds(v1.subtract(v2));
                }
                catch (IllegalArgumentException e) {
                    XPathException err = new XPathException("Overflow when subtracting two durations");
                    err.setErrorCode("FODT0002");
                    throw err;
                }
            }
            return DayTimeDurationValue.fromNanoseconds(this.getLengthInNanoseconds() - d2.getLengthInNanoseconds());
        }
        XPathException err = new XPathException("Cannot subtract two durations of different type");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    @Override
    public DurationValue negate() throws IllegalArgumentException {
        DayTimeDurationValue d2 = new DayTimeDurationValue();
        d2.setTypeLabel(this.typeLabel);
        d2._seconds = this._seconds;
        d2._nanoseconds = this._nanoseconds;
        d2._negative = !this._negative;
        return d2;
    }

    @Override
    public XPathComparable getXPathComparable(StringCollator collator, int implicitTimezone) {
        return this;
    }

    @Override
    public XPathComparable getXPathComparable() {
        return this;
    }

    @Override
    public int compareTo(XPathComparable other) {
        if (other instanceof DayTimeDurationValue) {
            Objects.requireNonNull(other);
            DayTimeDurationValue dtd = (DayTimeDurationValue)other;
            if (this._negative != dtd._negative) {
                return this._negative ? -1 : 1;
            }
            if (this._seconds != dtd._seconds) {
                return Long.compare(this._seconds, dtd._seconds) * (this._negative ? -1 : 1);
            }
            return Integer.compare(this._nanoseconds, dtd._nanoseconds) * (this._negative ? -1 : 1);
        }
        throw new ClassCastException("Cannot compare xs:dayTimeDuration to " + other);
    }

    @Override
    public AtomicMatchKey getXPathMatchKey(StringCollator collator, int implicitTimezone) {
        return this;
    }
}

