/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.nio.charset.StandardCharsets;
import net.sf.saxon.str.Twine8;
import net.sf.saxon.str.UnicodeString;

public class StringConstants {
    public static final UnicodeString SINGLE_SPACE = new Twine8(StringConstants.bytes(" "));
    public static final UnicodeString TRUE = new Twine8(StringConstants.bytes("true"));
    public static final UnicodeString FALSE = new Twine8(StringConstants.bytes("false"));
    public static final UnicodeString ONE = new Twine8(StringConstants.bytes("1"));
    public static final UnicodeString ZERO = new Twine8(StringConstants.bytes("0"));
    public static final UnicodeString ZERO_TO_NINE = new Twine8(StringConstants.bytes("0123456789"));
    public static final UnicodeString MIN_LONG = new Twine8(StringConstants.bytes("-9223372036854775808"));
    public static final UnicodeString POINT_ZERO = new Twine8(StringConstants.bytes(".0"));
    public static final UnicodeString ASTERISK = new Twine8(StringConstants.bytes("*"));
    public static final byte[] COMMENT_START = StringConstants.bytes("<!--");
    public static final byte[] COMMENT_END = StringConstants.bytes("-->");
    public static final byte[] TWO_HYPHENS = StringConstants.bytes("--");
    public static final byte[] PI_START = StringConstants.bytes("<?");
    public static final byte[] PI_END = StringConstants.bytes("?>");
    public static final byte[] EMPTY_TAG_MIDDLE = StringConstants.bytes("></");
    public static final byte[] EMPTY_TAG_END = StringConstants.bytes("/>");
    public static final byte[] EMPTY_TAG_END_XHTML = StringConstants.bytes(" />");
    public static final byte[] END_TAG_START = StringConstants.bytes("</");
    public static final byte[] ESCAPE_LT = StringConstants.bytes("&lt;");
    public static final byte[] ESCAPE_GT = StringConstants.bytes("&gt;");
    public static final byte[] ESCAPE_AMP = StringConstants.bytes("&amp;");
    public static final byte[] ESCAPE_NL = StringConstants.bytes("&#xA;");
    public static final byte[] ESCAPE_CR = StringConstants.bytes("&#xD;");
    public static final byte[] ESCAPE_TAB = StringConstants.bytes("&#x9;");
    public static final byte[] ESCAPE_QUOT = StringConstants.bytes("&#34;");
    public static final byte[] ESCAPE_APOS = StringConstants.bytes("&#39;");
    public static final byte[] ESCAPE_NBSP = StringConstants.bytes("&nbsp;");

    public static byte[] bytes(String s) {
        return s.getBytes(StandardCharsets.US_ASCII);
    }
}

