/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.io.IOException;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.Twine8;
import net.sf.saxon.str.UniStringConsumer;
import net.sf.saxon.str.UnicodeChar;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.str.UnicodeWriter;
import net.sf.saxon.str.ZenoString;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntIterator;

public final class UnicodeBuilder
implements UniStringConsumer,
UnicodeWriter {
    ZenoString content = ZenoString.of(EmptyUnicodeString.getInstance());

    public UnicodeBuilder() {
    }

    public UnicodeBuilder(int allocate) {
    }

    public UnicodeBuilder append(char ch) {
        this.content = this.content.concat(new UnicodeChar(ch));
        return this;
    }

    public UnicodeBuilder append(int codePoint) {
        this.content = this.content.concat(new UnicodeChar(codePoint));
        return this;
    }

    public UnicodeBuilder append(IntIterator codePoints) {
        while (codePoints.hasNext()) {
            this.append(codePoints.next());
        }
        return this;
    }

    public UnicodeBuilder appendLatin(String str) {
        return this.append(new BMPString(str));
    }

    public UnicodeBuilder appendAll(SequenceIterator iter) {
        Item item;
        while ((item = iter.next()) != null) {
            this.append(item.getUnicodeStringValue());
        }
        return this;
    }

    public UnicodeBuilder append(CharSequence str) {
        return this.append(StringTool.codePoints(str));
    }

    public UnicodeBuilder append(UnicodeString str) {
        this.content = this.content.concat(str);
        return this;
    }

    public long length() {
        return this.content.length();
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public UnicodeString toUnicodeString() {
        return this.content.economize();
    }

    public StringValue toStringItem(AtomicType type) {
        return new StringValue(this.toUnicodeString(), type);
    }

    public String toString() {
        return this.content.toString();
    }

    public void clear() {
        this.content = ZenoString.of(EmptyUnicodeString.getInstance());
    }

    public static byte[] expand1to2(byte[] in, int start, int used, int allocate) {
        byte[] result = new byte[allocate * 2];
        int i = start;
        int j = 0;
        while (i < used) {
            result[j++] = 0;
            result[j++] = in[i++];
        }
        return result;
    }

    public static char[] expandBytesToChars(byte[] in, int start, int end) {
        char[] result = new char[end - start];
        int i = start;
        int j = 0;
        while (i < end) {
            result[j++] = (char)in[i++];
        }
        return result;
    }

    public static byte[] expand1to3(byte[] in, int start, int used, int allocate) {
        byte[] result = new byte[allocate * 3];
        int i = start;
        int j = 0;
        while (i < used) {
            result[j++] = 0;
            result[j++] = 0;
            result[j++] = in[i++];
        }
        return result;
    }

    public static byte[] expand2to3(byte[] in, int start, int used, int allocate) {
        byte[] result = new byte[allocate * 3];
        int i = start;
        int j = 0;
        while (i < used) {
            result[j++] = 0;
            result[j++] = in[i++];
            result[j++] = in[i++];
        }
        return result;
    }

    public static byte[] expand(byte[] in, int start, int end, int oldWidth, int newWidth, int allocate) {
        if (allocate <= (end - start) / oldWidth) {
            allocate = (end - start) / oldWidth;
        }
        if (newWidth <= oldWidth) {
            byte[] out = new byte[allocate * newWidth];
            System.arraycopy(in, start, out, 0, end * oldWidth);
            return out;
        }
        if (oldWidth == 1 && newWidth == 2) {
            return UnicodeBuilder.expand1to2(in, start, end, allocate);
        }
        if (oldWidth == 1 && newWidth == 3) {
            return UnicodeBuilder.expand1to3(in, start, end, allocate);
        }
        if (oldWidth == 2 && newWidth == 3) {
            return UnicodeBuilder.expand2to3(in, start, end, allocate);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public UnicodeBuilder accept(UnicodeString chars) {
        return this.append(chars);
    }

    @Override
    public void write(UnicodeString chars) {
        this.append(chars);
    }

    @Override
    public void writeAscii(byte[] content) throws IOException {
        this.accept(new Twine8(content));
    }

    @Override
    public void write(String chars) throws IOException {
        this.append(chars);
    }

    public void trimToSize() {
    }

    @Override
    public void close() {
    }
}

