/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntSingletonSet;

public class Remove
extends SystemFunction {
    @Override
    public Expression makeFunctionCall(Expression[] arguments) {
        GroundedValue index;
        if (Literal.isAtomic(arguments[1]) && (index = ((Literal)arguments[1]).getGroundedValue()) instanceof IntegerValue) {
            try {
                long value = ((IntegerValue)index).longValue();
                if (value <= 0L) {
                    return arguments[0];
                }
                if (value == 1L) {
                    return new TailExpression(arguments[0], 2);
                }
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return super.makeFunctionCall(arguments);
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        IntSet removePositions;
        if (arguments[1] instanceof AtomicValue) {
            NumericValue n = (NumericValue)arguments[1].head();
            int pos = (int)n.longValue();
            if (pos < 1) {
                return arguments[0];
            }
            removePositions = new IntSingletonSet(pos);
        } else {
            NumericValue n;
            IntHashSet positions = new IntHashSet();
            SequenceIterator iter = arguments[1].iterate();
            while ((n = (NumericValue)iter.next()) != null) {
                int pos = (int)n.longValue();
                if (pos < 1) continue;
                positions.add(pos);
            }
            if (positions.isEmpty()) {
                return arguments[0];
            }
            removePositions = positions;
        }
        return SequenceTool.toLazySequence(new RemoveIterator(arguments[0].iterate(), removePositions));
    }

    @Override
    public String getStreamerName() {
        return "Remove";
    }

    public static class RemoveIterator
    implements SequenceIterator,
    LastPositionFinder {
        SequenceIterator base;
        IntSet removePositions;
        int basePosition = 0;
        Item current = null;

        public RemoveIterator(SequenceIterator base, IntSet removePosition) {
            this.base = base;
            this.removePositions = removePosition;
        }

        @Override
        public Item next() {
            this.current = this.base.next();
            ++this.basePosition;
            while (this.current != null && this.removePositions.contains(this.basePosition)) {
                this.current = this.base.next();
                ++this.basePosition;
            }
            return this.current;
        }

        @Override
        public void close() {
            this.base.close();
        }

        @Override
        public boolean supportsGetLength() {
            return SequenceTool.supportsGetLength(this.base);
        }

        @Override
        public int getLength() {
            int x;
            int result = x = SequenceTool.getLength(this.base);
            IntIterator iter = this.removePositions.iterator();
            while (iter.hasNext()) {
                int i = iter.next();
                if (i < 1 || i > x) continue;
                --result;
            }
            return result;
        }
    }
}

